<?php

namespace Modules\Announcement\Policies;

use Modules\Announcement\Entities\Announcement;
use Illuminate\Auth\Access\HandlesAuthorization;
use Modules\Admin\Entities\Admin;
use Modules\User\Entities\User;

class AnnouncementPolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the authenticate user can see the announcements.
     */
    public function viewAny(Admin|User $auth): bool
    {
        return $auth->hasPermission('announcement');
    }

    /**
     * Determine whether the authenticate user can create announcements.
     */
    public function create(Admin|User $auth): bool
    {
        return $auth->hasPermission('announcement');
    }

    /**
     * Determine whether the authenticate user can update the announcement.
     */
    public function update(Admin|User $auth, Announcement $model = null): bool
    {
        return $auth->hasPermission('announcement');
    }

    /**
     * Determine whether the authenticate user can delete the announcement.
     */
    public function delete(Admin|User $auth, Announcement $model): bool
    {
        return $auth->hasPermission('announcement');
    }

    /**
     * Determine whether the admin can restore the item.
     */
    public function restore(Admin|User $auth): bool
    {
        return $auth->hasPermission('announcement');
    }

    /**
     * Determine whether the admin can export the announcements.
     */
    public function export(Admin|User $auth): bool
    {
        return false;
    }
}
