<?php

namespace Modules\Announcement\Observers;

use Modules\Announcement\Entities\Announcement;
use Modules\Announcement\Entities\Device;

class AnnouncementObserver
{
    /**
     * Handle the model "created" event.
     */
    public function created(Announcement $announcement): void
    {
        $announcement->created_by = admin()?->id;
        $announcement->saveQuietly();

        $announcement->devices()->attach(Device::pluck('id'));

        if ($announcement->is_active) {
            Device::notifyToTopicFCM($announcement->title, $announcement->message);
        }
    }

    /**
     * Handle the model "updated" event.
     */
    public function updated(Announcement $announcement): void
    {
        //
    }

    /**
     * Handle the model "deleted" event.
     */
    public function deleted(Announcement $announcement): void
    {
        $announcement->updateQuietly([
            'is_active' => false,
            'deleted_by' => admin()?->id,
        ]);
    }

    /**
     * Handle the model "restored" event.
     */
    public function restored(Announcement $announcement): void
    {
        $announcement->updateQuietly([
            'deleted_by' => null,
        ]);
    }

    /**
     * Handle the model "force deleted" event.
     */
    public function forceDeleted(Announcement $announcement): void
    {
        //
    }
}
