<?php

namespace Modules\Announcement\Http\Requests;

use Modules\Announcement\Entities\Announcement;
use Illuminate\Validation\Rule;
use Illuminate\Foundation\Http\FormRequest;

class AnnouncementRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return (bool) admin();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        // $announcement = $this->route()->announcement;

        return [
            'title' => ['required', 'string', 'max:100'],
            'message' => ['nullable', 'string', 'max:200'],
            'is_active' => ['sometimes', 'boolean'],
        ];
    }

    /**
     * Get the validation attributes that apply to the request.
     *
     * @return array
     */
    public function attributes()
    {
        return [
            'is_active' => 'status active'
        ];
    }
}
