<?php

namespace Modules\Announcement\Exports;

use Illuminate\Http\Request;
use Modules\Announcement\Entities\Announcement;
use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithColumnFormatting;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\WithStyles;
use PhpOffice\PhpSpreadsheet\Shared\Date;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class AnnouncementsExport implements FromQuery, WithMapping, WithHeadings, WithStyles, WithColumnFormatting, ShouldAutoSize
{
    private $request;

    public function __construct(Request $request)
    {
        $this->request = $request;
    }

    public function styles(Worksheet $sheet)
    {
        return [
            1 => ['font' => ['bold' => true]],
        ];
    }

    public function headings(): array
    {
        return [
            [
                'id',
                'created_at',
                'updated_at',
            ]
        ];
    }

    public function query()
    {
        $announcements = Announcement::query();

        return $announcements;
    }

    public function map($announcement): array
    {
        return [
            $announcement->id,
            Date::dateTimeToExcel($announcement->created_at),
            Date::dateTimeToExcel($announcement->updated_at),
        ];
    }

    public function columnFormats(): array
    {
        return [
            'A' => NumberFormat::FORMAT_TEXT,
            'B' => NumberFormat::FORMAT_DATE_DATETIME,
            'C' => NumberFormat::FORMAT_DATE_DATETIME,
        ];
    }
}
