<?php

namespace Modules\Announcement\Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Modules\Announcement\Entities\Announcement;
use Modules\Announcement\Entities\Device;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Model>
 */
class AnnouncementFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = \Modules\Announcement\Entities\Announcement::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition()
    {
        return [
            'title' => str(fake()->realTextBetween(50, 80))->slug()->headline(),
            'message' => fake()->realText(),
            'is_active' => fake()->boolean(60),
            'created_by' => 1,
        ];
    }

    public function devices(): static
    {
        return $this->afterCreating(function (Announcement $announcement) {
            $announcement->devices()->attach(Device::pluck('id'), ['has_read' => fake()->boolean()]);
        });
    }
}
