
@inject('admin', Modules\Admin\Entities\Admin::class)

@extends('admin.layouts.base', [
    'title' => __('Admins Trashed'),
])

@section('header')
    @component('admin.layouts.headers.breadcrumbs')
        @slot('title')
            <i class="fas fa-user-cog fa-lg"></i>
        @endslot

        <li class="breadcrumb-item"><a href="{{ route('admin.index') }}">{{ __('Admins') }}</a></li>
        <li class="breadcrumb-item active" aria-current="page">{{ __('Trashed') }}</li>

        @slot('buttons')
            <a href="{{ route('admin.index') }}" class="btn btn-sm btn-neutral">{{ __('List All') }}</a>
        @endslot
    @endcomponent
@endsection

@section('content')
<div class="container-fluid mt--8">
    <div class="card">
        <div class="py-4">
            <table id="tableAdmin" class="table align-items-center table-flush" width="100%">
                <thead class="thead-light">
                    <tr>
                        <th>#</th>
                        @canany(['restore'], $admin)
                            <th>{{ __('Actions') }}</th>
                        @endcanany
                        <th>{{ __('Image') }}</th>
                        <th>{{ __('Name') }}</th>
                        <th>{{ __('Email') }}</th>
                        <th>{{ __('Contact') }}</th>
                        <th>{{ __('Status') }}</th>
                        <th>{{ __('Deleted At') }}</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</div>
@endsection

@include('admin.datatables.table', [
    'name' => 'Admin',
    'route' => route('admin.trashed'),
    'orders' => [7, 'desc'],
    'columns' => [
        get_dt_column_config('id'),
        get_dt_column_config('actions', orderable: false, searchable: false, entity: $admin, can: ['restore']),
        get_dt_column_config('avatar', orderable: false, searchable: false),
        get_dt_column_config('name'),
        get_dt_column_config('email'),
        get_dt_column_config('contact_no'),
        get_dt_column_config('status', 'is_active', searchable: false),
        get_dt_column_config('deleted_at', searchable: false),
    ]
])
