<div class="col-sm-5 col-md-4 mb-4 form-group">
    @if (admin()?->picture)
        <img src="{{ admin()?->avatar_path }}" class="rounded-circle img-thumbnail">
    @else
        <img src="{{ uno()->avatar }}" class="rounded-circle img-thumbnail">
    @endif
</div>
<div class="col-12 form-group">
    <label class="form-control-label" for="input-name">{{ __('Name') }} <sup class="text-danger">*</sup></label>
    <div class="{{ $errors->has('name') ? 'has-danger' : '' }}">
        <input type="text" name="name" id="input-name" class="form-control {{ $errors->has('name') ? 'is-invalid' : '' }}" placeholder="{{ __('Name') }}" value="{{ old('name', admin()?->name) }}" required autofocus>
    </div>
    @include('alerts.feedback', ['field' => 'name'])
</div>
<div class="col-lg-6 form-group">
    <label class="form-control-label" for="input-email">{{ __('Email') }} <sup class="text-danger">*</sup></label>
    <div class="{{ $errors->has('email') ? 'has-danger' : '' }}">
        <input type="email" name="email" id="input-email" class="form-control {{ $errors->has('email') ? 'is-invalid' : '' }}" placeholder="{{ __('Email') }}" value="{{ old('email', admin()?->email) }}" required autocomplete="new-email">
    </div>
    @include('alerts.feedback', ['field' => 'email'])
</div>
<div class="col-lg-6 form-group">
    <label class="form-control-label" for="input-contact_no">{{ __('Contact No.') }}</label>
    <div class="{{ $errors->has('contact_no') ? 'has-danger' : '' }}">
        <input type="tel" inputmode="numeric" name="contact_no"  id="input-contact_no" class="form-control {{ $errors->has('contact_no') ? 'is-invalid' : '' }}" placeholder="{{ __('Contact No.') }}" value="{{ old('contact_no', admin()?->contact_no) }}">
    </div>
    @include('alerts.feedback', ['field' => 'contact_no'])
</div>

@include('admin.components.fileinput', ['label' => 'Image', 'name' => 'photo', 'elfinder' => true])
