@extends('admin.layouts.base', [
    'title' => __('Edit Profile'),
])

@section('header')
    <h1 class="display-2 text-white pt-5 mb-3">{{ __('Hello') . ' '. admin()?->name }}!</h1>

    @include('alerts.success')
    @include('alerts.success', ['key' => 'password_status'])
    @include('alerts.errors')
@endsection

@section('content')
    <div class="container-fluid mt--8">
        <div class="row">
            <div class="col-8 position-relative">
                @component('admin.components.form')
                    @slot('edit', true)
                    @slot('title', __('Edit Profile'))
                    @slot('route', route('admin.profile.update'))

                    @include('admin::profile.form', ['edit' => true])
                @endcomponent

                @include('alerts.success', ['key' => 'password_status'])

                @component('admin.components.form')
                    @slot('edit', true)
                    @slot('title', __('Change Password'))
                    @slot('route', route('admin.profile.password'))

                    @include('admin::profile.password', ['edit' => true])
                @endcomponent
            </div>
        </div>
    </div>
@endsection

@includeFirst(['admin.components.toggle-password'])
