
@inject('admin', Modules\Admin\Entities\Admin::class)

@extends('admin.layouts.base', [
    'title' => __('Admins Management'),
])

@section('header')
    @component('admin.layouts.headers.breadcrumbs')
        @slot('title')
            <i class="fas fa-user-cog fa-lg"></i>
        @endslot

        <li class="breadcrumb-item"><a href="{{ route('admin.index') }}">{{ __('Admins') }}</a></li>
        <li class="breadcrumb-item active" aria-current="page">{{ __('List All') }}</li>

        @slot('buttons')
            @can('create', $admin)
                <a href="{{ route('admin.create') }}" class="btn btn-sm btn-neutral">{{ __('Create New') }}</a>
            @endcan

            @can('export', $admin)
                <a href="{{ route('admin.export', request()->query()) }}" class="btn btn-sm btn-primary">{{ __('Export Excel') }}</a>
            @endcan
        @endslot
    @endcomponent
@endsection

@section('content')
<div class="container-fluid mt--8">
    <div class="card">
        @component('admin.components.filter')
            @slot('status', true)
        @endcomponent

        <div class="py-4">
            <table id="tableAdmin" class="table align-items-center table-flush" width="100%">
                <thead class="thead-light">
                    <tr>
                        <th>#</th>
                        @canany(['update', 'delete'], $admin)
                            <th>{{ __('Actions') }}</th>
                        @endcanany
                        <th>{{ __('Avatar') }}</th>
                        <th>{{ __('Name') }}</th>
                        <th>{{ __('Email') }}</th>
                        <th>{{ __('Contact') }}</th>
                        <th>{{ __('Status') }}</th>
                        <th>{{ __('Created At') }}</th>
                        <th>{{ __('Updated At') }}</th>
                    </tr>
                </thead>
            </table>
        </div>
    </div>
</div>
@endsection

@include('admin.datatables.table', [
    'name' => 'Admin',
    'route' => route('admin.index'),
    'orders' => [7, 'desc'],
    'columns' => [
        get_dt_column_config('id'),
        get_dt_column_config('actions', orderable: false, searchable: false, entity: $admin, can: ['update', 'delete']),
        get_dt_column_config('avatar', orderable: false, searchable: false),
        get_dt_column_config('name'),
        get_dt_column_config('email'),
        get_dt_column_config('contact_no'),
        get_dt_column_config('status', 'is_active', searchable: false),
        get_dt_column_config('created_at', searchable: false),
        get_dt_column_config('updated_at', searchable: false),
    ]
])
