<div class="col-12 form-group">
    <label class="form-control-label" for="input-name">{{ __('Name') }} <sup class="text-danger">*</sup></label>
    <div class="{{ $errors->has('name') ? 'has-danger' : '' }}">
        <input type="text" name="name" id="input-name" class="form-control {{ $errors->has('name') ? 'is-invalid' : '' }}" placeholder="{{ __('Name') }}" value="{{ old('name', $admin->name) }}" autofocus required>
    </div>
    @include('alerts.feedback', ['field' => 'name'])
</div>

<div class="col-md-6 form-group">
    <label class="form-control-label" for="input-email">{{ __('Email') }} <sup class="text-danger">*</sup></label>
    <div class="{{ $errors->has('name') ? 'has-danger' : '' }}">
        <input type="email" name="email" id="input-email" class="form-control {{ $errors->has('email') ? 'is-invalid' : '' }}" placeholder="{{ __('Email') }}" value="{{ old('email', $admin->email) }}" required autocomplete="new-email">
    </div>
    @include('alerts.feedback', ['field' => 'email'])
</div>

<div class="col-md-6 form-group">
    <label class="form-control-label" for="input-contact_no">{{ __('Contact No.') }}</label>
    <div class="{{ $errors->has('contact_no') ? 'has-danger' : '' }}">
        <input type="tel" inputmode="numeric" name="contact_no"  id="input-contact_no" class="form-control {{ $errors->has('contact_no') ? 'is-invalid' : '' }}" placeholder="{{ __('Contact No.') }}" value="{{ old('contact_no', $admin->contact_no) }}">
    </div>
    @include('alerts.feedback', ['field' => 'contact_no'])
</div>

{{-- <div class="col-md-6 form-group">
    <label class="form-control-label" for="input-gender">{{ __('Gender') }} <sup class="text-danger">*</sup></label>
    <select name="gender" id="input-gender" class="form-control {{ $errors->has('gender') ? 'is-invalid' : '' }}" placeholder="{{ __('Gender') }}" required>
        @foreach (config('gender') as $key => $label)
            <option value="{{ $key }}" {{ $key == old('gender', $admin->gender) ? 'selected' : '' }}>{{ $label }}</option>
        @endforeach
    </select>
    @include('alerts.feedback', ['field' => 'gender'])
</div> --}}

@include('admin.components.fileinput', [
    'thumbnail' => [
        'delete' => asset_exists($admin->picture),
        'label' => 'avatar',
        'url' => $admin->avatar_path,
        'path' => $admin->picture,
        'policy' => 'update',
        'entity' => $admin::class,
        'hash' => $admin->hash_id,
    ],
    'label' => 'Avatar',
    'name' => 'photo',
    'uploaded' => $admin->exists ? ['url' => $admin->avatar_path, 'path' => $admin->picture] : [],
])

{{-- @empty($edit) --}}
    <div class="col-12 form-group">
        <hr class="mb-0 mt-2">
    </div>

    <div class="col-md-6 form-group">
        <label class="form-control-label" for="input-password">
            {{ __('Password') }} @empty($edit) <sup class="text-danger">*</sup> @endempty
        </label>
        <div class="{{ $errors->has('password') ? 'has-danger' : '' }} toggle-password">
            <input type="password" name="password" id="input-password" class="form-control {{ $errors->has('password') ? 'is-invalid' : '' }}" placeholder="{{ __('Password') }}" @empty($edit) required @endempty autocomplete="new-password">
        </div>
        @include('alerts.feedback', ['field' => 'password'])
    </div>

    <div class="col-md-6 form-group">
        <label class="form-control-label" for="input-password-confirmation">
            {{ __('Confirm Password') }} @empty($edit) <sup class="text-danger">*</sup> @endempty
        </label>
        <div class="{{ $errors->has('password') ? 'has-danger' : '' }} toggle-password">
            <input type="password" name="password_confirmation" id="input-password-confirmation" class="form-control" placeholder="{{ __('Confirm Password') }}" @empty($edit) required @endempty autocomplete="new-password">
        </div>
    </div>
{{-- @endempty --}}

<div class="col-12 form-group d-flex align-items-center">
    <label class="form-control-label mb-0 mr-3">{{ __('Status Active') }} <sup class="text-danger">*</sup></label>
    <label class="custom-toggle">
        <input type="checkbox" name="is_active" value="1" {{ old('is_active', $admin->is_active) ? 'checked' : '' }}>
        <span class="custom-toggle-slider rounded-circle" data-label-off="No" data-label-on="Yes"></span>
    </label>
</div>

@if (!$admin?->isSuperAdmin() && (admin()?->id != $admin->id))
    <div class="col-12 form-group">
        <hr class="mb-0 mt-2">
    </div>

    <div class="col-12 form-group">
        <label class="form-control-label">{{ __('Module Permissions') }}</label>
    </div>

    <div class="col-12">
        <div class="row row-cols-1 row-cols-sm-2 row-cols-md-3 row-cols-lg-4">
            @foreach ($admin::getModulesList() as $module)
                <div class="col form-group d-flex align-items-center">
                    <label class="form-control-label mb-0 mr-3">{{ ucwords(str($module)->plural()) }}</label>
                    <label class="custom-toggle ml-auto mr-5">
                        <input type="checkbox" name="permissions[]" value="{{ $module }}" @checked(in_array($module, old('permissions', $admin->permissions ?? [])))>
                        <span class="custom-toggle-slider rounded-circle" data-label-off="No" data-label-on="Yes"></span>
                    </label>
                </div>
            @endforeach
        </div>
    </div>
@endif

@includeFirst(['admin.components.toggle-password'])

