@extends('admin.layouts.base', [
    'title' => __('Create New Admin'),
])

@section('header')
    @component('admin.layouts.headers.breadcrumbs')
        @slot('title')
            <i class="fas fa-user-cog fa-lg"></i>
        @endslot

        <li class="breadcrumb-item"><a href="{{ route('admin.index') }}">{{ __('Admins') }}</a></li>
        <li class="breadcrumb-item active" aria-current="page">{{ __('Create New') }}</li>

        @slot('buttons')
            <a href="{{ route('admin.index') }}" class="btn btn-sm btn-neutral">{{ __('List All') }}</a>
        @endslot
    @endcomponent
@endsection

@section('content')
    <div class="container-fluid mt--8">
        <div class="row">
            <div class="col-xl-12 order-xl-1">
                @component('admin.components.form')
                    @slot('title', __('New Admin'))
                    @slot('route', route('admin.store'))

                    @include('admin::form', ['admin' => $admin])
                @endcomponent
            </div>
        </div>
    </div>
@endsection

@push('css')
@endpush

@push('vendor-js')
@endpush

@push('js')
@endpush
