<?php

namespace Modules\Admin\Policies;

use Modules\Admin\Entities\Admin;
use Illuminate\Auth\Access\HandlesAuthorization;

class AdminPolicy
{
    use HandlesAuthorization;

    /**
     * Determine whether the admin can see the admins.
     *
     * @param  \Modules\Admin\Entities\Admin $admin
     * @return boolean
     */
    public function viewAny(Admin $admin)
    {
        return $admin->hasPermission('admin');
    }

    /**
     * Determine whether the authenticate user can create admins.
     *
     * @param  \Modules\Admin\Entities\Admin $admin
     * @return boolean
     */
    public function create(Admin $admin)
    {
        return $admin->hasPermission('admin');
    }

    /**
     * Determine whether the authenticate user can update the admin.
     *
     * @param  \Modules\Admin\Entities\Admin $admin
     * @param  \Modules\Admin\Entities\Admin $model
     * @return boolean
     */
    public function update(Admin $admin, Admin $model)
    {
        return $admin->hasPermission('admin') || $model->id == $admin->id;
    }

    /**
     * Determine whether the authenticate user can delete the admin.
     *
     * @param  \Modules\Admin\Entities\Admin $admin
     * @param  \Modules\Admin\Entities\Admin $model
     * @return boolean
     */
    public function delete(Admin $admin, Admin $model) {
        return $admin->hasPermission('admin') && $admin->id != $model->id;
    }

    /**
     * Determine whether the admin can restore the item.
     *
     * @param  \Modules\Admin\Entities\Admin $admin
     * @return boolean
     */
    public function restore(Admin $admin)
    {
        return $admin->hasPermission('admin');
    }

    /**
     * Determine whether the admin can export the admins.
     *
     * @param  \Modules\Admin\Entities\Admin $admin
     * @return boolean
     */
    public function export(Admin $admin)
    {
        return false;
    }
}
