<?php

namespace Modules\Admin\Observers;

use Modules\Admin\Entities\Admin;
use Illuminate\Support\Facades\Storage;

class AdminObserver
{
    /**
     * Handle the model "created" event.
     */
    public function created(Admin $admin): void
    {
        $admin->updateQuietly([
            'email_verified_at' => now()
        ]);
    }

    /**
     * Handle the model "updated" event.
     */
    public function updated(Admin $admin): void
    {
        if ($admin->wasChanged('picture')) {
            destroy_asset($admin->getOriginal('picture'));
        }
    }

    /**
     * Handle the model "deleted" event.
     */
    public function deleted(Admin $admin): void
    {
        $admin->updateQuietly([
            'is_active' => false
        ]);
    }

    /**
     * Handle the model "restored" event.
     */
    public function restored(Admin $admin): void
    {
        //
    }

    /**
     * Handle the model "force deleted" event.
     */
    public function forceDeleted(Admin $admin): void
    {
        destroy_asset($admin->getOriginal('picture'));
    }
}
