<?php

namespace Modules\Admin\Http\Requests;

use Modules\Admin\Entities\Admin;
use Illuminate\Validation\Rule;
use Illuminate\Foundation\Http\FormRequest;

class ProfileRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return (bool) admin();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'name' => ['required', 'string'],
            'email' => ['required', 'email', Rule::unique((new Admin)->getTable())->ignore(admin()?->id)],
            'contact_no' => ['nullable', 'string'],
            'photo' => file_validation($this->get('photo')),
        ];
    }

    public function attributes()
    {
        return [
            'photo' => 'image',
        ];
    }
}
