<?php

namespace Modules\Admin\Http\Requests;

use Modules\Admin\Entities\Admin;
use Illuminate\Validation\Rule;
use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rules\Password;

class AdminRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return (bool) admin();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $admin = $this->route()->admin;

        return [
            'name' => ['required', 'string'],
            'email' => ['required', 'email', Rule::unique((new Admin)->getTable())->ignore($admin->id ?? null)],
            'password' => [$admin ? 'nullable' : 'required', 'string', 'confirmed', Password::defaults()],
            'photo' => file_validation($this->get('photo')),
            'contact_no' => ['nullable', 'string'],
            'is_active' => ['sometimes', 'boolean'],
            // 'gender' => ['required', Rule::in(array_keys(config('gender')))],
            'permissions' => ['sometimes', 'nullable', 'array'],
            'permissions.*' => [Rule::in(Admin::getModulesList())],
        ];
    }

    /**
     * Get the validation attributes that apply to the request.
     *
     * @return array
     */
    public function attributes()
    {
        return [
            'photo' => 'image',
            'is_active' => 'status',
        ];
    }
}
