<?php

namespace Modules\Admin\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Storage;
use Modules\Admin\Http\Requests\ProfileRequest;
use Modules\Admin\Http\Requests\PasswordRequest;

class ProfileController extends Controller
{
    /**
     * Show the form for editing the profile.
     *
     * @return \Illuminate\View\View
     */
    public function edit()
    {
        return view('admin::profile.edit');
    }

    /**
     * Update the profile
     *
     * @param  \Modules\Admin\Http\Requests\ProfileRequest  $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function update(ProfileRequest $request)
    {
        admin()?->update(
            $request->merge([
                'picture' => $request->has('photo') ? (is_string($request->photo) ? $request->photo : $request->photo->store('files/avatars', 'public')) : null,
            ])->except([$request->hasFile('photo') ? '' : 'picture'])
        );

        return redirect()->route('admin.profile.edit')->withStatus(__('Profile successfully updated.'));
    }

    /**
     * Change the password
     *
     * @param  \Modules\Admin\Http\Requests\PasswordRequest  $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function password(PasswordRequest $request)
    {
        admin()?->update(['password' => Hash::make($request->get('password'))]);

        return redirect()->route('admin.profile.edit')->withPasswordStatus(__('Password successfully updated.'));
    }
}
