<?php

namespace Modules\Admin\Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Facades\Hash;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Model>
 */
class AdminFactory extends Factory
{
    /**
     * The name of the factory's corresponding model.
     *
     * @var string
     */
    protected $model = \Modules\Admin\Entities\Admin::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition()
    {
        return [
            'name' => $name = fake()->name(),
            'email' => fake()->unique()->safeEmail,
            'contact_no' => fake()->phoneNumber(),
            'picture' => fallback_via_placeholder(fake()->imageUrl(category: $name, randomize: false)),
            'gender' => fake()->numberBetween(1, 2),
            'password' => Hash::make('password'),
            'is_active' => fake()->boolean(),
            'email_verified_at' => fake()->dateTime()
        ];
    }
}
